<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
require '../../modelo/reclamo_devolucion.php';

$response = array();

if (!isset($_POST['id_reclamo_devolucion'])) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

$id_reclamo_devolucion = $_POST['id_reclamo_devolucion'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('reclamo_devolucion', $id_reclamo_devolucion));

$delete_result = ReclamoDevolucion::mdlDeleteReclamoDevolucion($id_reclamo_devolucion);

if (!$delete_result) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo eliminar el reclamo de devolución';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('delete', 'reclamo_devolucion', $id_reclamo_devolucion, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = true;

echo json_encode($response);