<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

error_reporting(E_ALL);
error_reporting(-1);
ini_set('error_reporting', E_ALL);

require '../../modelo/producto.php';
require '../../modelo/producto_categoria.php';
require '../../modelo/subcategoria.php';
require '../../modelo/categoria.php';
require '../../modelo/pregunta.php';
require '../../modelo/calificacion_producto.php';
require '../../modelo/producto_variacion.php';
require '../../modelo/precio.php';
require '../../modelo/wishlist.php';
require '../../modelo/odoo_producto.php';
require '../../modelo/odoo_lista_precio.php';
require '../usuario/decodeUsuario.php';

function getProductoDetalle($producto, $id_usuario)
{
    $precio_regular = Precio::mdlGetPrecioById($producto['id_precio']);

    $objeto_precio = [
        'id_precio_regular' => $producto['id_precio'],
        'precio_regular' => $precio_regular['precio'],
        'precio_descuento' => null,
        // 'id_precio_descuento' => $precio_regular['fecha_baja'],
        // 'descuento_porcentaje' => $producto['id_producto'],
    ];

    // $producto['precio']['id_precio_regular'] = $producto['id_precio'];
    // $producto['precio']['precio_regular'] = $precio_regular['precio'];
    // $producto['precio']['precio_descuento'] = null;

    $precio_descuento = Precio::mdlGetPrecioById($producto['id_precio_descuento']);

    if ($producto['id_precio_descuento'] !== null && ($precio_descuento['fecha_baja'] >= date('Y-m-d') || $precio_descuento['fecha_baja'] === null)) {

        // $producto['precio']['id_precio_descuento'] = $producto['id_precio_descuento'];
        // $producto['precio']['precio_descuento'] = $precio_descuento['precio'];

        $procentaje_descuento = 100 - ($producto['precio']['precio_descuento'] * 100) / $producto['precio']['precio_regular'];
        // $producto['precio']['descuento_porcentaje'] = ceil($procentaje_descuento);
        
        $objeto_precio['precio_descuento'] = $precio_descuento['precio'];
        $objeto_precio['id_precio_descuento'] = $producto['id_precio_descuento'];
        $objeto_precio['descuento_porcentaje'] = ceil($procentaje_descuento);
    }

    $producto['precio'] = $objeto_precio;

    $imagenes = json_decode($producto['imagenes']);
    $imagenes_url = array();
    $url_servidor = Environment::getUrlServidor();

    foreach ($imagenes as $key_imagen => $imagen) {
        $imagenes_url[$key_imagen]['id_imagen'] = $imagen->id;
        $imagenes_url[$key_imagen]['url_imagen'] = $url_servidor . $imagen->url;
    }

    $producto['imagenes'] = $imagenes_url;

    $calificacion = Producto::mdlGetCalificacionesProducto($producto['id_producto']);

    $producto['total_calificaciones'] = $calificacion['total_calificaciones'];
    $producto['promedio'] = number_format($calificacion['promedio_estrellas'], 2);

    $producto['wishlist'] = $id_usuario !== null && Wishlist::mdlVerificarExistenciaWishlist($id_usuario, $producto['id_producto']);

    // Obtenemos la URL de la categoria y subcategoria
    $categorias = ProductoCategoria::mdlGetCategoriaAndSubcategoriaById($producto['id_producto']);
    $id_categoria = $categorias['id_categoria'];
    $id_subcategoria = $categorias['id_subcategoria'];
    $data_categoria = Categoria::mdlGetCategoriaById($id_categoria);
    $data_subcategoria = Subcategoria::mdlGetSubcategoriaById($id_subcategoria);

    $producto['url_pagina_categoria'] = $data_categoria['url_pagina'];
    $producto['url_pagina_subcategoria'] = $data_subcategoria['url_pagina'];

    return $producto;
}

if (!isset($_POST['url_pagina'])) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$url_pagina = $_POST['url_pagina'];

$id_usuario = isset($_POST['id_usuario']) ? DecodeUser::handlePostUsuario($_POST['id_usuario']) : null;

$producto_inicial = Producto::mdlGetProductoByURL($url_pagina);

if (!$producto_inicial) {
    $response['response'] = 'error';
    $response['data'] = 'No se encontró el producto.';
    echo json_encode($response);
    return;
}

$id_producto = $producto_inicial['id_producto'];

$atributo_variacion = isset($_POST['atributo_variacion']) ? $_POST['atributo_variacion'] : null;
$producto_variaciones = ProductoVariacion::mdlGetProductoVariacionByIdProductoPadre($id_producto, $atributo_variacion);

$producto = getProductoDetalle($producto_inicial, $id_usuario);

if (count($producto_variaciones) > 0) {
    $variaciones = array();
    foreach ($producto_variaciones as $key => $variacion) {
        $producto_variacion = Producto::mdlGetProductoById($variacion['id_producto']);
        $producto_aux = getProductoDetalle($producto_variacion, $id_usuario);

        $nombre_variacion = $variacion['nombre_variacion'];

        $variaciones[$key]['id_tipo_variacion'] = $variacion['id_tipo_variacion'];
        $variaciones[$key]['tipo_variacion'] = $nombre_variacion;
        $variaciones[$key]['nombre'] = $variacion['atributo_variacion'];
        $variaciones[$key][$nombre_variacion] = $variacion['valor_atributo_variacion'];

        $variaciones[$key]['id_producto'] = $producto_aux['id_producto'];
        $variaciones[$key]['id_producto_odoo'] = $producto_aux['id_producto_odoo'];
        $variaciones[$key]['nombre_producto'] = $producto_aux['nombre'];
        $variaciones[$key]['sku'] = $producto_aux['sku'];
        $variaciones[$key]['imagenes'] = $producto_aux['imagenes'];
        $variaciones[$key]['precio'] = $producto_aux['precio'];

        // $precio_regular = Precio::mdlGetPrecioById($producto_variacion['id_precio']);

        // $variaciones[$key]['precio']['id_precio_regular'] = $producto['id_precio'];
        // $variaciones[$key]['precio']['precio_regular'] = $precio_regular['precio'];
        // $variaciones[$key]['precio']['precio_descuento'] = null;

        // $precio_descuento = Precio::mdlGetPrecioById($producto['id_precio_descuento']);

        // if ($producto['id_precio_descuento'] !== null && ($precio_descuento['fecha_baja'] >= date('Y-m-d') || $precio_descuento['fecha_baja'] === null)) {

        //     $producto['precio']['id_precio_descuento'] = $producto['id_precio_descuento'];
        //     $producto['precio']['precio_descuento'] = $precio_descuento['precio'];

        //     $procentaje_descuento = 100 - ($producto['precio']['precio_descuento'] * 100) / $producto['precio']['precio_regular'];
        //     $producto['precio']['descuento_porcentaje'] = ceil($procentaje_descuento);
        // }
    }
}

$producto['variaciones'] = $variaciones;

$preguntas = Pregunta::mdlGetPreguntaRespuestaByIdProducto($id_producto);

$resenas = CalificacionProducto::mdlGetCalificacionProductosResenasByIdProducto($id_producto);

if ($resenas !== false || $resenas !== null) {
    foreach ($resenas as $key => $resena) {
        if (is_null($resena['uid_google']) && is_null($resena['uid_facebook'])) {
            $resenas[$key]['foto_perfil'] = Environment::getUrlServidor() . $resena['foto_perfil'];
        }

        unset($resenas[$key]['uid_google']);
        unset($resenas[$key]['uid_facebook']);

        if ($resena['imagen_resena'] != null) {
            $imagenes = json_decode($resena['imagen_resena']);
            $imagenes_url = array();
            $url_servidor = Environment::getUrlServidor();

            foreach ($imagenes as $key_imagen => $imagen) {
                $imagenes_url[$key_imagen]['id_imagen'] = $imagen->id_imagen;
                $imagenes_url[$key_imagen]['url_imagen'] = $url_servidor . $imagen->url_imagen;
            }
        }

        $resenas[$key]['imagen_resena'] = $imagenes_url;
    }
}

Producto::mdlUpdateVisitas($id_producto);

$response['response'] = 'success';
$response['data'] = $producto;
$response['resenas'] = (!$resenas) ? [] : $resenas;
$response['preguntas'] = (!$preguntas) ? [] : $preguntas;

echo json_encode($response);
