<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/producto.php';
require '../../modelo/wishlist.php';
require '../../modelo/precio.php';
require '../../modelo/odoo_producto.php';
require '../../modelo/odoo_lista_precio.php';
require '../../modelo/producto_variacion.php';
require '../usuario/decodeUsuario.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);

$response = array();
$filtrosBusqueda = array();

$preciosMaxMin = Producto::mdlGetRangoPrecios();

$pagina = isset($_POST['pagina']) ? intval($_POST['pagina']) : 1;
$limite = isset($_POST['limite']) ? intval($_POST['limite']) : 12;

$order = (isset($_POST['order'])) ? $_POST['order'] : 'ASC';

if (isset($_POST['fecha'])) {
    $filtrosBusqueda['fecha'] = $_POST['fecha'];
}

if (isset($_POST['precio'])) {
    $filtrosBusqueda['precio'] = $_POST['precio'];
}

if (isset($_POST['precio_max'])) {
    $filtrosBusqueda['precio_max'] = intval($_POST['precio_max']);
}

if (isset($_POST['precio_min'])) {
    $filtrosBusqueda['precio_min'] = intval($_POST['precio_min']);
}

if (isset($_POST['categoria'])) {
    $filtrosBusqueda['categoria'] = $_POST['categoria'];

    $preciosMaxMinCategoria = Producto::mdlGetRangoPreciosByCategoria($_POST['categoria']);
    $filtrosBusqueda['precio_min'] = $preciosMaxMinCategoria['precio_min'];
    $filtrosBusqueda['precio_max'] = $preciosMaxMinCategoria['precio_max'];
}

if (isset($_POST['proveedor'])) {
    $filtrosBusqueda['proveedor'] = $_POST['proveedor'];
}

if (isset($_POST['termino_busqueda'])) {
    $termino_busqueda = $_POST['termino_busqueda'];
    $productos = Producto::mdlGetProductosBusqueda($termino_busqueda, $filtrosBusqueda, $order);
} else {
    $productos = Producto::mdlGetProductosCategoriaFiltros($filtrosBusqueda);
}

$productos_variacion_padre = array();

if (!$productos) {
    $response['response'] = 'error';
    $response['data'] = [];
    echo json_encode($response);
    return;
}

foreach ($productos as $key_variaciones => $producto) {
    $id_producto = $producto['id_producto'];

    $producto_variacion = ProductoVariacion::mdlGetProductoVariacionByIdProducto($id_producto);

    if (($producto_variacion === false) || ($producto_variacion['id_producto'] === $producto_variacion['id_producto_padre'])) {
        $productos_variacion_padre[$key_variaciones] = $producto;
    }
}

$total_productos = count($productos_variacion_padre);
$total_paginas = ceil($total_productos / $limite);

if ($pagina < 1) {
    $pagina = 1;
} elseif ($pagina > $total_paginas) {
    $pagina = $total_paginas;
}

$offset = ($pagina - 1) * $limite;

$paginado_productos = array_slice($productos_variacion_padre, $offset, $limite);

if (!$paginado_productos) {
    $response['response'] = 'error';
    $response['data'] = [];
    echo json_encode($response);
    return;
}

$id_usuario = isset($_POST['id_usuario']) ? DecodeUser::handlePostUsuario($_POST['id_usuario']) : null;

foreach ($paginado_productos as $key => $producto) {
    $id_producto = $producto['id_producto'];

    $precio_regular = Precio::mdlGetPrecioById($producto['id_precio']);

    $paginado_productos[$key]['precio']['id_precio_regular'] = $producto['id_precio'];
    $paginado_productos[$key]['precio']['precio_regular'] = $precio_regular['precio'];
    $paginado_productos[$key]['precio']['precio_descuento'] = null;

    if ($producto['id_precio_descuento'] !== null) {
        $precio_descuento = Precio::mdlGetPrecioById($producto['id_precio_descuento']);

        $paginado_productos[$key]['precio']['id_precio_descuento'] = $producto['id_precio_descuento'];
        $paginado_productos[$key]['precio']['precio_descuento'] = $precio_descuento['precio'];

        $procentaje_descuento = 100 - ($paginado_productos[$key]['precio']['precio_descuento'] * 100) / $paginado_productos[$key]['precio']['precio_regular'];

        $paginado_productos[$key]['precio']['descuento_porcentaje'] = ceil($procentaje_descuento);
    }

    $imagenes = json_decode($producto['imagenes']);
    $imagenes_url = array();
    $url_servidor = Environment::getUrlServidor();

    foreach ($imagenes as $key_imagen => $imagen) {
        $imagenes_url[$key_imagen]['id_imagen'] = $imagen->id;
        $imagenes_url[$key_imagen]['url_imagen'] = $url_servidor . $imagen->url;
    }

    $paginado_productos[$key]['imagenes'] = $imagenes_url;

    $calificacion = Producto::mdlGetCalificacionesProducto($id_producto);
    $paginado_productos[$key]['total_calificaciones'] = $calificacion['total_calificaciones'];
    $paginado_productos[$key]['promedio'] = $calificacion['promedio_estrellas'];

    $paginado_productos[$key]['wishlist'] = false;

    $paginado_productos[$key]['wishlist'] = $id_usuario !== null && Wishlist::mdlVerificarExistenciaWishlist($id_usuario, $id_producto);

    $variaciones = ProductoVariacion::mdlGetProductoVariacionByIdProductoPadre($id_producto);
    $paginado_productos[$key]['variaciones'] = $variaciones;
}

$response['response'] = 'success';
$response['data'] = $paginado_productos;
$response['precio_min'] = $preciosMaxMin['precio_min'];
$response['precio_max'] = $preciosMaxMin['precio_max'];
$response['total_paginas'] = $total_paginas;
$response['pagina_actual'] = $pagina;

echo json_encode($response);
