<?php

error_reporting(E_ALL);
error_reporting(-1);
ini_set('error_reporting', E_ALL);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/producto.php';
require '../../modelo/precio.php';
require '../../modelo/producto_categoria.php';
require '../../modelo/odoo_producto.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/global.php';
require '../../modelo/history.php';

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['id_odoo']) ||
    !isset($_POST['nombre']) ||
    !isset($_POST['peso']) ||
    !isset($_POST['precio_sin_iva']) ||
    !isset($_POST['precio_con_iva']) ||
    !isset($_POST['ancho']) ||
    !isset($_POST['largo']) ||
    !isset($_POST['alto']) ||
    !isset($_POST['sku']) ||
    !isset($_POST['id_proveedor']) ||
    !isset($_POST['id_categoria']) ||
    !isset($_POST['id_subcategoria'])
    // !isset($_POST['alto']) ||
    // !isset($_POST['ancho']) ||
    // !isset($_POST['largo']) ||
) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);
if (!$id_usuario) {
    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

// Estos datos vienen directo de Odoo
$id_odoo = $_POST['id_odoo'];
$nombre = $_POST['nombre'];
$peso = $_POST['peso'];
$precio_sin_iva = $_POST['precio_sin_iva'];
$precio_con_iva = $_POST['precio_con_iva'];
$sku = $_POST['sku'];
// Obtener el alto, ancho y alto como un numero entero aleatorio entre el 1 y el 100
$alto = $_POST['alto'];
$ancho = $_POST['ancho'];
$largo = $_POST['largo'];

// Estos datos son elegidos por el usuario
$id_proveedor = $_POST['id_proveedor'];
$id_categoria = $_POST['id_categoria'];
$id_subcategoria = $_POST['id_subcategoria'];

// 1. Damos de alta el producto en la base de datos para obtener su id_producto
$id_producto = Producto::mdlAddProductoOdoo(
    $id_odoo,
    $nombre,
    $sku,
    $id_proveedor,
    $peso,
    $alto,
    $ancho,
    $largo
);

if (!$id_producto) {
    $response['response'] = 'error';
    $response['message'] = 'Error al agregar el producto en la base de datos';
    echo json_encode($response);
    return;
}

// 2. Damos de alta el precio del producto en la base de datos
$etiqueta_precio = NULL; // <--- Se usa solo cuando se agregan los cupones
$id_precio = Precio::mdlAddPrecio($precio_con_iva, $precio_sin_iva, $etiqueta_precio, $id_producto);

if (!$id_precio) {
    // Si no se pudo agregar el precio, eliminamos el producto de la base de datos
    Producto::mdlDeleteProducto($id_producto);
    $response['response'] = 'error';
    $response['message'] = 'Error al agregar el precio del producto en la base de datos';
    echo json_encode($response);
    return;
}

// 2.1 Vinculamos el nuevo precio al producto
Producto::mdlUpdatePrecio($id_producto, $id_precio);

// 3. Damos de alta la relación entre el producto y la categoría en la base de datos
$id_producto_categoria = ProductoCategoria::mdlAddCategoriaAndSubcategoriaByProducto($id_producto, $id_categoria, $id_subcategoria);

if (!$id_producto_categoria) {
    // Si no se pudo agregar la relación, eliminamos el producto y el precio de la base de datos
    Producto::mdlDeleteProducto($id_producto);
    Precio::mdlDeletePrecio($id_precio);
    $response['response'] = 'error';
    $response['message'] = 'Error al agregar la relación entre el producto y la categoría en la base de datos';
    echo json_encode($response);
    return;
}

// 4. Agregamos todo al historial de producto, precio y producto_categoria
ModeloHistory::mdlAddNewRegister('create', 'producto', $id_producto, $id_usuario, NULL);
ModeloHistory::mdlAddNewRegister('create', 'precio', $id_precio, $id_usuario, NULL);
ModeloHistory::mdlAddNewRegister('create', 'producto_categoria', $id_producto_categoria, $id_usuario, NULL);

$response['response'] = 'success';
$response['message'] = 'Producto agregado correctamente';
echo json_encode($response);