<?php

// Se debe incluír para permitir el paso de datos en localhost a la app de React
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include "./../../modelo/permiso_usuario.php";
require './../usuario/decodeUsuario.php';

$array = array();

if (
    !isset($_POST['id_usuario'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$permisos = PermisoUsuario::mdlGetPermisoByUsuario($id_usuario);

if(!$permisos){
    $array['response'] = 'error';
    $array['message'] = 'No tiene permisos';
    echo json_encode($array);
    return;
}

$array['response'] = 'success';
$array['data'] = $permisos;

echo json_encode($array);

http_response_code(200);

?>