<?php

require '../../modelo/carrito.php';
require '../../modelo/orden.php';
require '../envio/costo_envio.php';
require '../envio/costo_paqueteria.php';
require '../usuario/decodeUsuario.php';

$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['paqueteria']) ||
    !isset($_POST['cp'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);
$paqueteria = $_POST['paqueteria'];
$cp = $_POST['cp'];

$carrito = Carrito::mdlGetCarritoByIdUsuario($id_usuario);

if (!$carrito) {
    $response['response'] = 'error';
    $response['data'] = 'No se encontró la orden';
    echo json_encode($response);
    return;
}


$costo_envio = Envio::getOrdenOdoo($cp, $carrito, $paqueteria);
echo json_encode($costo_envio);

// if (!$costo_envio) {
//     $response['response'] = 'error';
//     $response['data'] = 'No se encontró el costo de envío';
//     echo json_encode($response);
//     return;
// }

$cliente = OdooCliente::getClientIdByRFCOrEmail($rfc, 'YIRE@YOPMAIL.COM');

echo json_encode($cliente);
