<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/orden.php';
require '../../modelo/producto_orden.php';
require '../../modelo/pago.php';
require '../../modelo/environment.php';
require '../usuario/decodeUsuario.php';
$response = array();

if (
    !isset($_POST['id_usuario'])
) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = $_POST['id_usuario'];
$limite = 10;
$productos_orden = Orden::mdlGetOrdenesByIdUsuarioLimit($id_usuario, $limite);

if (!$productos_orden) {
    $response['response'] = 'error';
    $response['message'] = 'No se encontraron ordenes';
    echo json_encode($response);
    return;
}

$ordenes = array();

foreach ($productos_orden as $key => $producto) {
    $total = 0;

    $ordenes[$key]['id_orden'] = $producto['id_orden'];
    $ordenes[$key]['numero_orden'] = $producto['numero_orden'];
    $ordenes[$key]['fecha'] = $producto['fecha_alta'];
    $ordenes[$key]['id_estado_orden'] = $producto['id_estado_orden'];
    $ordenes[$key]['estado_orden'] = $producto['estado_orden'];

    $producto_orden = ProductoOrden::mdlGetProductoOrdenByIdOrden($producto['id_orden']);

    foreach ($producto_orden as $producto_orden => $info_producto) {
        $ordenes[$key]['productos'][$producto_orden]['nombre'] = $info_producto['nombre'];

        $imagenes = json_decode($info_producto['imagenes']);
        $url_servidor = Environment::getUrlServidor();
        $ordenes[$key]['productos'][$producto_orden]['url_imagen'] = $url_servidor . $imagenes[0]->url;
        $ordenes[$key]['productos'][$producto_orden]['color_categoria'] = $info_producto['color_categoria'];
    }
    $transaccion = Pago::mdlGetPagoByIdOrden($producto['id_orden']);
    $ordenes[$key]['total'] = $transaccion['cantidad_pago'];

    $fecha = date($producto['fecha_alta']);
    $fechaFormat = strftime("%B %d, %Y", strtotime($fecha));
    $ordenes[$key]['fecha_alta'] = $fechaFormat;
}

$response['response'] = 'success';
$response['data'] = $ordenes;
echo json_encode($response);
