<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/conexion.php';
require '../../modelo/material_extra.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/global.php';
require '../../modelo/history.php';

$response = array();

if (!isset($_POST['id_material_extra']) || !isset($_POST['id_usuario'])) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_material_extra = $_POST['id_material_extra'];

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('material_extra', $id_material_extra));

$material_extra = MaterialExtra::mdlDeleteMaterialExtra($id_material_extra);

if (!$material_extra) {
    $response['response'] = 'error';
    $response['message'] = 'No se eliminó el material extra';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('delete', 'material_extra', $id_material_extra, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = true;

echo json_encode($response);
