<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/conexion.php';
require '../../modelo/faq.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/global.php';
require '../../modelo/history.php';

$response = array();

if (
    !isset($_POST['id_faq']) ||
    !isset($_POST['pregunta']) ||
    !isset($_POST['respuesta']) ||
    // !isset($_POST['visitas']) ||
    // !isset($_POST['predeterminada']) ||
    // !isset($_POST['activo']) ||
    !isset($_POST['id_usuario'])
) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_faq = $_POST['id_faq'];
$pregunta = $_POST['pregunta'];
$respuesta = $_POST['respuesta'];
// $visitas = $_POST['visitas'];
// $predeterminada = $_POST['predeterminada'];
// $activo = $_POST['activo'];

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('faq', $id_faq));

// $faq = Faq::mdlUpdateFaq($id_faq, $pregunta, $respuesta, $visitas, $predeterminada, $activo);
$faq = Faq::mdlUpdatePreguntaYRespuesta($id_faq, $pregunta, $respuesta);

if (!$faq) {
    $response['response'] = 'error';
    $response['message'] = 'No se actualizó la FAQ';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'faq', $id_faq, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = true;

echo json_encode($response);