<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/pago.php';
require '../../modelo/pago_soporte_tecnico.php';
require '../../modelo/cita_soporte_tecnico.php';
require '../../modelo/orden.php';
require '../usuario/decodeUsuario.php';

if (!isset($_POST['id'], $_POST['fecha_inicial'], $_POST['fecha_final'])) {
    $response['response'] = 'error';
    echo json_encode($response);
    return;
}

// 0. Validamos que sea un usuario autorizado por nuestro servidor para leer la información
$id_usuario = DecodeUser::handlePostUsuario($_POST['id']);
if (!$id_usuario) {
    $response['response'] = 'error';
    $response['message'] = 'Id del usuario no válido';
    echo json_encode($response);
    return;
}

// 1. Obtendremos todos los ingresos que hay de las órdenes entre determinadas fechas.
$fecha_inicial = $_POST['fecha_inicial'];
$fecha_final = $_POST['fecha_final'];

// 1.1. Definimos las variables que utilizaremos
$total_ingresos_ordenes = 0;
$total_ingresos_citas = 0;
$total_ordenes = 0;
$total_citas = 0;

$query_ingresos = Pago::mdlGetTotalIngresosEntreFechas($fecha_inicial, $fecha_final);
$total_ingresos_ordenes = is_null($query_ingresos['total']) ? 0 : $query_ingresos['total'];

// 2. También los ingresos por citas de soporte técnico, y sumaremos los totales.
$query_ingresos_citas = PagoSoporteTecnico::mdlGetTotalIngresosEntreFechas($fecha_inicial, $fecha_final);
$total_ingresos_citas = is_null($query_ingresos_citas['total']) ? 0 : $query_ingresos_citas['total'];

// 3. Obtenemos el número total de ordenes y de citas de soporte técnico.
$query_total_ordenes = Orden::mdlGetTotalOrdenesEntreFechas($fecha_inicial, $fecha_final);
$total_ordenes = is_null($query_total_ordenes['total']) ? 0 : $query_total_ordenes['total'];

$query_total_citas = CitaSoporteTecnico::mdlGetTotalCitasEntreFechas($fecha_inicial, $fecha_final);
$total_citas = is_null($query_total_citas['total']) ? 0 : $query_total_citas['total'];

// 4. Brindamos esos datos
$response['response'] = 'success';
$response['data'] = array(
    'total_ingresos' => floatval($total_ingresos_ordenes) + floatval($total_ingresos_citas),
    'total_ordenes' => $total_ordenes,
    'total_citas' => $total_citas
);
echo json_encode($response);
