<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

error_reporting(E_ALL);
error_reporting(-1);
ini_set('error_reporting', E_ALL);

require '../../modelo/cita_soporte_tecnico.php';

$response = array();

$horarios = [
    ['id_hora' => 1, 'hora' => (new DateTime('09:00:00'))->format('H:i')],
    ['id_hora' => 2, 'hora' => (new DateTime('10:00:00'))->format('H:i')],
    ['id_hora' => 3, 'hora' => (new DateTime('11:00:00'))->format('H:i')],
    ['id_hora' => 4, 'hora' => (new DateTime('12:00:00'))->format('H:i')],
    ['id_hora' => 5, 'hora' => (new DateTime('13:00:00'))->format('H:i')],
    ['id_hora' => 6, 'hora' => (new DateTime('14:00:00'))->format('H:i')],
    ['id_hora' => 7, 'hora' => (new DateTime('15:00:00'))->format('H:i')],
    ['id_hora' => 8, 'hora' => (new DateTime('16:00:00'))->format('H:i')],
    ['id_hora' => 9, 'hora' => (new DateTime('17:00:00'))->format('H:i')],
];

if (!isset($_POST['fecha'])) 
{
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$fecha = $_POST['fecha'];
$date = DateTime::createFromFormat('Y-m-d, H:i:s', $fecha);
$formattedDate = $date->format('Y-m-d');

$citas_soporte_tecnico = CitaSoporteTecnico::mdlGetHorariosCitaSoporteTecnicoByDia($formattedDate);

if(!$citas_soporte_tecnico)
{
    $response['response'] = 'success';
    $response['data'] = $horarios;
    echo json_encode($response);
    return;
}

foreach ($citas_soporte_tecnico as $cita_soporte_tecnico) {
    // $horario_cita_soporte = date('H:i:s', strtotime($cita_soporte_tecnico['fecha_hora']));
    $horario_cita_soporte = (new DateTime($cita_soporte_tecnico['fecha_hora']))->format('H:i');
    foreach ($horarios as $key => $horario) {
        if ($horario['hora'] == $horario_cita_soporte) {
            unset($horarios[$key]);
            break;
        }
    }
}

$horario_final = array_values($horarios);

$response['response'] = 'success';
$response['data'] = $horario_final;

echo json_encode($response);