<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/ruta.php';
require '../../modelo/categoria.php';
require '../../modelo/subcategoria.php';
require '../../modelo/producto.php';

$categorias = Categoria::mdlGetCategorias();
$response = array();

if (!$categorias) {
    $response['response'] = 'error';
    $response['data'] = 'No se encontraron categorias';
    echo json_encode($response);
    return;
} 

foreach ($categorias as $key => $value) {
    $id_categoria = $value['id_categoria'];

    // Obtenemos una imagen de alguna subcategoria de la categoria
    $subcategoria = Subcategoria::mdlGetSubcategoriaByCategoriaActivo($id_categoria);
    if ($subcategoria) {
        $categorias[$key]['imagen'] = Ruta::getRutaSitioAdministracion() . '/' . $subcategoria[0]['imagen'];
    } else {
        $categorias[$key]['imagen'] = Ruta::getRutaSitioAdministracion() . '/vistas/img/categorias/default.jpg';
    }

    $_subcategorias = [];
    $subcategorias = Subcategoria::mdlGetSubcategoriaByCategoriaActivo($id_categoria);
    if (!$subcategorias) {
        $subcategorias = $_subcategorias;    
    }

    if($subcategorias) {
        foreach ($subcategorias as $keySub => $valueSub) {
            $subcategorias[$keySub]['imagen'] = Ruta::getRutaSitioAdministracion() . '/' . $valueSub['imagen'];
        }
    }

    $categorias[$key]['subcategorias'] = $subcategorias;

    $totalProductos = Producto::mdlGetProductosCategoria($id_categoria);
    if (is_array($totalProductos)) {
        $categorias[$key]['totalProductos'] = $totalProductos['total'];
    } else {
        $categorias[$key]['totalProductos'] = 0;
    }
}

$response['response'] = 'success';
$response['data'] = $categorias;
echo json_encode($response);