<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/catalogo.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['catalogos'])
) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

// Los catalogos vienen de un stringificado JSON
$catalogos = json_decode($_POST['catalogos'], true);

$update = true;
// Iterar sobre cada catalogo y actualizar su orden
foreach ($catalogos as $key => $catalogo) {
    $id_catalogo = $catalogo['id_catalogo'];
    $orden = $catalogo['orden'];
    // Consultar si ya existe un catalogo con ese orden
    $exist = Catalogo::mdlIsCatalogoOrderExist($id_catalogo, $orden);
    
    // Si ya existe, saltar al siguiente
    if ($exist) {
        continue;
    }

    $valor_anterior = json_encode(ModeloGlobal::mdlSelect('catalogo', $id_catalogo));
    $update = Catalogo::mdlUpdateOrdenCatalogo($id_catalogo, $orden);
    ModeloHistory::mdlAddNewRegister('update', 'catalogo', $catalogo['id_catalogo'], $id_usuario, $valor_anterior);
}


if (!$update) {
    $response['response'] = 'error';
    $response['message'] = 'No se pudo actualizar el orden del catalogo';
    echo json_encode($response);
    return;
}

$response['response'] = 'success';
$response['data'] = $catalogo;
echo json_encode($response);
