<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/catalogo.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

// VALIDAR SI LOS CAMPOS EXISTEN
if (!isset(
    $_POST['id_usuario'],
    $_POST['id_catalogo']
)) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

// VALIDAR SI EXISTE EL PDF
if (!isset($_FILES['pdf']['name'])) {
    $response['response'] = 'error';
    $response['message'] = 'No hay PDF';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

// VALIDAR SI EL USUARIO EXISTE
if (!$id_usuario) {

    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';

    echo json_encode($response);
    return;
}

$id_catalogo = $_POST['id_catalogo'];

$pdf = $_FILES['pdf']['name'];

$extension = pathinfo($pdf, PATHINFO_EXTENSION);
$nombrePDF = uniqid() . "-" . $id_catalogo . '.' . $extension;

$pdfRuta = '../../assets/pdf/catalogo/' . $nombrePDF;

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('catalogo', $id_catalogo));

if (!move_uploaded_file($_FILES['pdf']['tmp_name'], $pdfRuta)) {
    $response['response'] = 'error';
    $response['message'] = 'No se pudo subir el PDF';
    echo json_encode($response);
    return;
}

$rutaFinal = "assets/pdf/catalogo/" . $nombrePDF;

if (!Catalogo::mdlUpdateCatalogoPDF($id_catalogo, $rutaFinal)) {
    $response['response'] = 'error';
    $response['message'] = 'No se pudo actualizar el PDF';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'catalogo', $id_catalogo, $id_usuario, $valor_anterior);
$response['response'] = 'success';
$response['data'] = true;
echo json_encode($response);
