<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/carrito.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['productos']) ||
    !isset($_POST['id_usuario'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$productos = json_decode($_POST['productos']);

foreach ($productos as $key => $value) {
    $producto_eliminado = Carrito::mdlDeleteCarritoByProductoUsuario($id_usuario, $value);

    if (!$producto_eliminado) {
        $response['response'] = 'error';
        $response['data'] = 'No se eliminó el producto del carrito';
        // echo json_encode($response);
    }
}

$response['response'] = 'success';
$response['data'] = 'Productos eliminados del carrito';
echo json_encode($response);