<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/carrito.php';
require '../../modelo/usuario.php';
require '../../modelo/correo.php';

$carritosAbandonados = Carrito::mdlObtenerCarritosAbandonados24Hrs();

if ($carritosAbandonados === false) {
    return "No abandoned carts found";
}

$productosAgrupados = [];
foreach ($carritosAbandonados as $carrito) {
    $id_usuario = $carrito['id_usuario'];
    if (!isset($productosAgrupados[$id_usuario])) {
        $productosAgrupados[$id_usuario] = [];
    }
    $productosAgrupados[$id_usuario][] = $carrito;
}

foreach ($productosAgrupados as $id_usuario => $carritos) {
    $usuario = Usuario::mdlGetUsuarioActivo($id_usuario, 1);
    $nombre = $usuario['nombre'];
    $correo = $usuario['correo'];
    
    $enviar_correo = Correo::mdlCarritoAbandonado($correo, $nombre, $carritos);

    if (!$enviar_correo) {
        $response['response'] = 'error';
        $response['data'] = 'No se pudo enviar el correo';
        echo json_encode($response);
    }
}
