<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/card_publicitario.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['id_card_publicitario']) ||
    !isset($_POST['activo'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_card_publicitario = $_POST['id_card_publicitario'];
$activo = $_POST['activo'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('card_publicitario', $id_card_publicitario));

$card_publicitario = CardPublicitario::mdlUpdateActivoCardPublicitario($id_card_publicitario, $activo);

if (!$card_publicitario) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo actualizar el campo activo.';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'card_publicitario', $card_publicitario, $id_usuario, $valor_anterior);
$response['response'] = 'success';
$response['card_publicitario'] = $card_publicitario;

echo json_encode($response);
return;
