<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/card_publicitario.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

if (
    !isset($_POST['id_usuario']) &&
    !isset($_POST['titulo']) &&
    !isset($_POST['descripcion']) &&
    !isset($_POST['link']) &&
    !isset($_POST['id_card_publicitario']) &&
    !isset($_POST['color_fondo']) &&
    !isset($_POST['color_texto']) &&
    !isset($_POST['texto_boton'])
) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$titulo = $_POST['titulo'];
$descripcion = $_POST['descripcion'];
$link = $_POST['link'];
$id_card_publicitario = $_POST['id_card_publicitario'];
$color_fondo = $_POST['color_fondo'];
$color_texto = $_POST['color_texto'];
$texto_boton = $_POST['texto_boton'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('card_publicitario', $id_card_publicitario));

$cardPublicitario = CardPublicitario::mdlUpdateCardPublicitario($id_card_publicitario, $titulo, $descripcion, $link, $color_fondo, $texto_boton, $color_texto);

if ($cardPublicitario) {
    ModeloHistory::mdlAddNewRegister('update', 'card_publicitario', $id_card_publicitario, $id_usuario, $valor_anterior);
} 


$response['response'] = 'success';
$response['data'] = $cardPublicitario;
echo json_encode($response);
