<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/calificacion_producto.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

if (
    isset($_POST['id_usuario']) &&
    isset($_POST['id_calificacion_producto']) &&
    isset($_POST['calificacion']) &&
    isset($_POST['comentario']) &&
    isset($_POST['activo'])
) {
    $id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

    if (!$id_usuario) {
        $response['response'] = 'error';
        $response['data'] = 'Id del usuario incorrecto.';
        echo json_encode($response);
        return;
    }

    $id_calificacion_producto = $_POST['id_calificacion_producto'];
    $calificacion = $_POST['calificacion'];
    $comentario = $_POST['comentario'];
    $activo = $_POST['activo'];

    $valor_anterior = json_encode(ModeloGlobal::mdlSelect('calificacion_producto', $id_calificacion_producto));

    $calificacion_producto = CalificacionProducto::mdlUpdateCalificacionProducto($id_calificacion_producto, $calificacion, $comentario, $activo);

    if (!$calificacion_producto) {
        $response['response'] = 'error';
        $response['data'] = 'No se pudo actualizar la calificación del producto.';
    } else {
        ModeloHistory::mdlAddNewRegister('update', 'calificacion_producto', $calificacion_producto, $id_usuario, $valor_anterior);
        $response['response'] = 'success';
        $response['data'] = $calificacion_producto;
    }

    echo json_encode($response);
    return;
} else {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}