<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/calificacion_producto.php';
require '../../modelo/environment.php';
// require '../calificacion/decodeCalificacion.php';

$url_servidor = Environment::getUrlServidor();
const LIMITE_DE_CALIFICACIONES_POR_PAGINA = 20;

$numero_pagina = ($_POST['numero_pagina'] - 1);
$offset = $numero_pagina * LIMITE_DE_CALIFICACIONES_POR_PAGINA;

$termino_busqueda = $_POST['termino_busqueda'];
$orderBy = json_decode($_POST['orderBy'], true);
$filters = json_decode($_POST['filters'], true);

$calificaciones = CalificacionProducto::mdlSearchLimit($filters, $termino_busqueda, $orderBy, $offset, LIMITE_DE_CALIFICACIONES_POR_PAGINA);
$total_calificaciones = CalificacionProducto::mdlSearchTotal($filters, $termino_busqueda);

if (!$calificaciones) {
    $response['response'] = 'error';
    $response['message'] = 'No se encontraron calificaciones';
    echo json_encode($response);
    return;
}

foreach ($calificaciones as $key => $calificacion) {
    $respuesta = $calificacion['respuesta'];
    // $calificaciones[$key]['atendido'] = !is_null($respuesta) ? '1' : '0';

    $calificaciones[$key]['nombre_completo'] = $calificacion['nombre'] . ' ' . $calificacion['apellido_paterno'] . ' ' . $calificacion['apellido_materno'];
    $fecha = date($calificacion['fecha_alta']);
    $fechaFormat = strftime("%B %d, %Y %H:%M", strtotime($fecha));
    $calificaciones[$key]['fecha_alta'] = $fechaFormat;

    // Agregamos la primera imagen del producto y su color de categoria para identificarlo
    if(!is_null($calificacion['imagenes_producto'])){
        $imagenes = json_decode($calificacion['imagenes_producto']);
        $imagenes_url = array();
    
        $calificaciones[$key]['url_imagen'] = $url_servidor . $imagenes[0]->url;
    }


    // Le agregamos la ruta a las imagenes de la calificación
    if($calificacion['imagen_resena'] != null) {
        $imagenes_resena = json_decode($calificacion['imagen_resena']);
        $imagenes_url = array();
        
        foreach ($imagenes_resena as $key_imagen => $value) {
            $imagenes_url[$key_imagen]['id_imagen'] = $value->id_imagen;
            $imagenes_url[$key_imagen]['url_imagen'] = $url_servidor . $value->url_imagen;
        }
    }

    $calificaciones[$key]['imagen_resena'] = $imagenes_url;

    $calificaciones[$key]['color_fondo'] = $calificacion['color_categoria'];
    
}

$response['response'] = 'success';
$response['data'] = array(
    "calificaciones" => $calificaciones,
    "total_calificaciones" => $total_calificaciones['total'],
    "limite" => LIMITE_DE_CALIFICACIONES_POR_PAGINA,
);

echo json_encode($response);