<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/banner.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['titulo']) ||
    !isset($_POST['url_destino']) ||
    !isset($_POST['id_banner'])
) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$titulo = $_POST['titulo'];
$descripcion = NULL;
$url_destino = $_POST['url_destino'];
$id_banner = $_POST['id_banner'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('banner', $id_banner));

$banner = Banner::mdlUpdateBanner($id_banner, $titulo, $descripcion, $url_destino);

if (!$banner) {
    $response['response'] = 'success';
    $response['message'] = 'No hay nada que actualizar';
    echo json_encode($response);
    return;
} 

ModeloHistory::mdlAddNewRegister('update', 'banner', $id_banner, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = $banner;
echo json_encode($response);